<?php
/**
 * @version		$Id: url.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

/**
 * Decorates a URL link
 *
 * If the http prefix is not supplied, one will be added
 *
 * @static
 * @package		JXtended.Libraries
 * @subpackage	Forms
 */
class JXDecoratorUrl
{
	function render($value, $text = '', $options = null)
	{
		if (strpos($value, 'http') !== 0) {
			$value = 'http://'.$value;
		}
		return JHTML::link($value, ($text ? $text : $value), $options);
	}
}