<?php
/**
 * @version		$Id: registrygroup.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jximport('jxtended.form.field');

/**
 * JXtended Form Field Type Class for a registry group input.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeRegistrygroup extends JXFieldType
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'Registrygroup';

	function fetchField($name, $value, &$node, $controlName)
	{
		if (is_string($value)) {
			$params = new JParameter($value);
			$values = $params->toArray();
		} else {
			$values = (array) $value;
		}
		$fields = array();
		if (!empty($node->group)) {
			foreach ($node->group as $group)
			{
				foreach ($group->param as $param)
				{
					// Special cases
					$pName = $param->attributes('name');
					$value	= (isset($values[$pName]) AND $values[$pName] !== '') ? $values[$pName] : $param->attributes('default', null);
					$prefix	= $controlName.$name;
					$fields[$group->attributes('title')][$pName] = $this->_getField($param, $value, $prefix);
				}
			}
		}

		return $fields;
	}

	/**
	 * Render a form field
	 *
	 * @access	public
	 * @param	object	$node			An JXFormField object
	 * @param	mixed	$value			The field value
	 * @param	string	$controlName	The field control name
	 * @return	object	Rendered Form Field object
	 * @since	1.5
	 */
	function _getField(&$node, $value, $controlName = 'jxform[params]')
	{
		// get the field type
		$type = $node->attributes('type');

		// load the field type object
		$field = &$this->_parent->loadFieldType($type);

		// field type could not be loaded -- just return some basic information
		if ($field === false) {
			$field = &$this->_parent->loadFieldType('text');
		}

		return $field->render($node, $value, $controlName);
	}
}