<?php
/**
 * @version		$Id: assetgroups.php 420 2009-07-24 00:24:45Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');

/**
 * List form field type object
 *
 * @package		JXtended.Libraries
 */
class JXFieldTypeList_AssetGroups extends JXFieldTypeList
{
	function _getOptions(&$node)
	{
		$db			= &JFactory::getDBO();

		// Check that JXtended Control is installed.
		$tables = $db->getTableList();
		if (in_array($db->getPrefix().'core_acl_axo_groups', $tables))
		{
			$options	= array(
				JHtml::_('select.optgroup', JText::_('Global'))
			);

			// Load the global groups first
			$query = new JXQuery;
			$query->select('a.value, a.name AS text');
			$query->from('#__core_acl_axo_groups AS a');
			//$query->where('a.section_id = 1');
			$query->where('parent_id <> 0');
			$query->order('a.name');

			$db->setQuery($query->toString());
			$options	= array_merge($options, $db->loadObjectList());

			// Now load any section based groups
			$sections	= $node->attributes('sections');
			$sections	= explode(',', $sections);
			if (!empty($sections))
			{

				foreach ($sections as $i => $section) {
					$sections[$i] = $db->quote($section);
				}

				$query = new JXQuery;
				$query->select('a.value, a.name AS text');
				$query->from('#__core_acl_axo_groups AS a');
				$query->join('INNER', '#__core_acl_axo_sections AS s ON s.id = a.section_id');
				$query->where('s.value IN ('.implode($sections).')');
				$query->where('parent_id <> 0');
				$query->order('a.name');

				$db->setQuery($query->toString());
				$temp = $db->loadObjectList();
				if (!empty($temp)) {
					array_push($options, JHtml::_('select.optgroup', JText::_('Local')));
					$options = array_merge($options, $temp);
				}
			}
		}
		else
		{
			// Load the global groups first

			$query = new JXQuery;
			$query->select('a.id AS value, a.name AS text');
			$query->from('#__groups AS a');
			$query->order('a.id');

			$db->setQuery($query->toString());
			$options	= $db->loadObjectList();
		}

		return $options;
	}
}