<?php
/**
 * @version		$Id: hidden.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jximport('jxtended.form.field');

/**
 * JXtended Form Field Type Class for a hidden input.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeHidden extends JXFieldType
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'Hidden';

	function fetchField($name, $value, &$node, $controlName)
	{
		$id		= str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name));
		$class	= ($node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="text_area"');

		return '<input type="hidden" name="'.$controlName.'['.$name.']" id="'.$id.'" value="'.htmlspecialchars($value).'" '.$class.' />';
	}
}