<?php
/**
 * @version		$Id: arogroup.php 184 2008-12-23 04:05:39Z eddieajau $
 * @copyright	Copyright (C) 2008 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License
 */

defined('_JEXEC') or die('Restricted access');

require_once dirname(__FILE__).DS.'_aclgroup.php';

/**
 * Table object for ARO (User) Groups.
 *
 * @package		JXtended.Libraries
 * @subpackage	Acl
 * @version		1.0
 */
class JxTableAroGroup extends JxTable_AclGroup
{
	/**
	 * @var	string The group type
	 * @protected
	 */
	var $_type = 'aro';

	/**
	 * Find the references to this AXO
	 *
	 * This method can only operate on a previously loaded object.
	 *
	 * @return	JxAclReferences
	 * @access	public
	 */
	function &findReferences()
	{
		if (empty($this->_references))
		{
			// Allow the parent method to run first, do validation checks and set up the reference object
			if (parent::findReferences() !== false)
			{
				$this->_db->setQuery(
					'SELET a.id, a.section_value'.
					' FROM #__core_acl_groups_aro_map AS m'.
					' LEFT JOIN #__core_acl_aro AS a ON a.id = m.aro_id'.
					' WHERE group_id = '.(int) $this->id
				);
				$values = $this->_db->loadObjectList();
				if (!$this->_db->query()) {
					$this->setError($this->_db->getErrorMsg());
					return false;
				}
				if (!empty($result)) {
					foreach ($result as $aro) {
						$this->_references->addAro($aro->section_value, $aro->id);
					}
				}
			}
		}

		return $this->_references;
	}
}
