<?php
/**
 * @version		$Id: helper.php 254 2009-01-07 23:57:23Z louis $
 * @package		JXtended.Libraries
 * @subpackage	User
 * @copyright	Copyright (C) 2005 - 2009 Open Source Matters, Inc. All rights reserved.
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

/**
 * User helper class for JXtended Libraries.
 *
 * @package		JXtended.Libraries
 * @subpackage	User
 * @version		1.0
 */
class JXUserHelper
{
	/**
	 * Method to add a user to a group.
	 *
	 * @access	public
	 * @param	integer		$userId		The id of the user.
	 * @param	integer		$groupId	The id of the group.
	 * @return	mixed		Boolean true on success, JException on error.
	 * @since	1.0
	 */
	function addUserToGroup($userId, $groupId)
	{
		// Add the table include path and then initialize the table with JUser.
		JTable::addIncludePath(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'jxtended'.DS.'database'.DS.'table');
		JUser::getTable('User', 'JXTable');

		// Get the user object.
		$user = new JUser($userId);

		// Add the user to the group if necessary.
		if (!array_key_exists($groupId, $user->groups))
		{
			// Get the title of the group.
			$db	= &JFactory::getDBO();
			$db->setQuery(
				'SELECT `title`' .
				' FROM `#__usergroups`' .
				' WHERE `id` = '.(int)$groupId
			);
			$title = $db->loadResult();

			// Check for a database error.
			if ($db->getErrorNum()) {
				return new JException($db->getErrorMsg());
			}

			// If the group does not exist, return an exception.
			if (!$title) {
				return new JException(JText::_('ACCESS USERGROUP INVALID'));
			}

			// Add the group data to the user object.
			$user->groups[$groupId] = $title;

			// Store the user object.
			if (!$user->save()) {
				return new JException($user->getError());
			}
		}

		// Set the group data for any preloaded user objects.
		$temp = &JFactory::getUser($userId);
		$temp->groups = $user->groups;

		// Set the group data for the user object in the session.
		$temp = &JFactory::getUser();
		if ($temp->id == $userId) {
			$temp->groups = $user->groups;
		}

		return true;
	}

	/**
	 * Method to get a list of groups a user is in.
	 *
	 * @access	public
	 * @param	integer		$userId		The id of the user.
	 * @return	mixed		Array on success, JException on error.
	 * @since	1.0
	 */
	function getUserGroups($userId)
	{
		// Add the table include path and then initialize the table with JUser.
		JTable::addIncludePath(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'jxtended'.DS.'database'.DS.'table');
		JUser::getTable('User', 'JXTable');

		// Get the user object.
		$user = new JUser($userId);

		return isset($user->groups) ? $user->groups : array();
	}

	/**
	 * Method to remove a user from a group.
	 *
	 * @access	public
	 * @param	integer		$userId		The id of the user.
	 * @param	integer		$groupId	The id of the group.
	 * @return	mixed		Boolean true on success, JException on error.
	 * @since	1.0
	 */
	function removeUserFromGroup($userId, $groupId)
	{
		// Add the table include path and then initialize the table with JUser.
		JTable::addIncludePath(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'jxtended'.DS.'database'.DS.'table');
		JUser::getTable('User', 'JXTable');

		// Get the user object.
		$user = new JUser($userId);

		// Remove the user from the group if necessary.
		if (array_key_exists($groupId, $user->groups))
		{
			// Remove the user from the group.
			unset($user->groups[$groupId]);

			// Store the user object.
			if (!$user->save()) {
				return new JException($user->getError());
			}
		}

		// Set the group data for any preloaded user objects.
		$temp = &JFactory::getUser($userId);
		$temp->groups = $user->groups;

		// Set the group data for the user object in the session.
		$temp = &JFactory::getUser();
		if ($temp->id == $userId) {
			$temp->groups = $user->groups;
		}

		return true;
	}

	/**
	 * Method to set the groups for a user.
	 *
	 * @access	public
	 * @param	integer		$userId		The id of the user.
	 * @param	array		$groups		An array of group ids to put the user in.
	 * @return	mixed		Boolean true on success, JException on error.
	 * @since	1.0
	 */
	function setUserGroups($userId, $groups)
	{
		// Add the table include path and then initialize the table with JUser.
		JTable::addIncludePath(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'jxtended'.DS.'database'.DS.'table');
		JUser::getTable('User', 'JXTable');

		// Get the user object.
		$user = new JUser($userId);

		// Set the group ids.
		JArrayHelper::toInteger($groups);
		$user->groups = array_fill_keys(array_values($groups), null);

		// Get the titles for the user groups.
		$db = &JFactory::getDBO();
		$db->setQuery(
			'SELECT `id`, `title`' .
			' FROM `#__usergroups`' .
			' WHERE `id` = '.implode(' OR `id` = ', array_keys($user->groups))
		);
		$results = $db->loadObjectList();

		// Check for a database error.
		if ($db->getErrorNum()) {
			return new JException($db->getErrorMsg());
		}

		// Set the titles for the user groups.
		for ($i = 0, $n = count($results); $i < $n; $i++) {
			$user->groups[$results[$i]->id] = $results[$i]->title;
		}

		// Store the user object.
		if (!$user->save()) {
			return new JException($user->getError());
		}

		// Set the group data for any preloaded user objects.
		$temp = &JFactory::getUser($userId);
		$temp->groups = $user->groups;

		// Set the group data for the user object in the session.
		$temp = &JFactory::getUser();
		if ($temp->id == $userId) {
			$temp->groups = $user->groups;
		}

		return true;
	}
}