<?php
/**
 * @version		$Id: integers.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');
jximport('jxtended.form.fields.list');

/**
 * JXtended Form Field Type Class for a list of integers.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeIntegers extends JXFieldTypeList
{
	function _getOptions(&$node)
	{
		$first		= (int) $node->attributes('first');
		$last		= (int) $node->attributes('last');
		$step		= (int) max(1, $node->attributes('step'));

		$options	= array();
		for ($i = $first; $i <= $last; $i += $step)
		{
			$options[] = JHTML::_('select.option', $i);
		}
		return $options;
	}
}