<?php
/**
 * @version		$Id: files.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');
jximport('jxtended.form.fields.list');

/**
 * JXtended Form Field Type Class for a list of files.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeFiles extends JXFieldTypeList
{
	function _getOptions(&$node)
	{
		jximport('joomla.filesystem.folder');
		jximport('joomla.filesystem.file');

		// path to images directory
		$path		= JPATH_ROOT.DS.$node->attributes('directory');
		$filter		= $node->attributes('filter');
		$exclude	= $node->attributes('exclude');
		$stripExt	= $node->attributes('stripext');
		$files		= JFolder::files($path, $filter);

		$options = array ();

		if (is_array($files))
		{
			foreach ($files as $file)
			{
				if ($exclude)
				{
					if (preg_match(chr(1) . $exclude . chr(1), $file))
					{
						continue;
					}
				}
				if ($stripExt)
				{
					$file = JFile::stripExt($file);
				}
				$options[] = JHTML::_('select.option', $file, $file);
			}
		}

		return $options;
	}
}