--
-- Table structure for table `jos_access_actions`
--

CREATE TABLE IF NOT EXISTS `jos_access_actions` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `section_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_sections.id',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `description` text,
  `access_type` int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_action_name_lookup` (`section_id`,`name`),
  KEY `idx_acl_manager_lookup` (`access_type`,`section_id`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_action_rule_map`
--

CREATE TABLE IF NOT EXISTS `jos_access_action_rule_map` (
  `action_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_actions.id',
  `rule_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_rules.id',
  PRIMARY KEY  (`action_id`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_assetgroups`
--

CREATE TABLE IF NOT EXISTS `jos_access_assetgroups` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL default '0' COMMENT 'Adjacency List Reference Id',
  `left_id` int(10) unsigned NOT NULL default '0' COMMENT 'Nested Set Reference Id',
  `right_id` int(10) unsigned NOT NULL default '0' COMMENT 'Nested Set Reference Id',
  `title` varchar(100) NOT NULL default '',
  `section_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_sections.id',
  `section` varchar(100) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`section`,`title`),
  KEY `idx_assetgroup_adjacency_lookup` (`parent_id`),
  KEY `idx_assetgroup_nested_set_lookup` USING BTREE (`left_id`,`right_id`, `section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jos_access_assetgroups`
--

INSERT INTO `jos_access_assetgroups` (`id`, `parent_id`, `left_id`, `right_id`, `title`, `section_id`, `section`) VALUES
(1, 0, 1, 6, 'Public', 1, 'core'),
(2, 1, 2, 3, 'Registered', 1, 'core'),
(3, 1, 4, 5, 'Special', 1, 'core');

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_assetgroup_rule_map`
--

CREATE TABLE IF NOT EXISTS `jos_access_assetgroup_rule_map` (
  `group_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_assetgroups.id',
  `rule_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_rules.id',
  PRIMARY KEY  (`group_id`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_assets`
--

CREATE TABLE IF NOT EXISTS `jos_access_assets` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `section_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_sections.id',
  `section` varchar(100) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_asset_name_lookup` (`section_id`,`name`),
  KEY `idx_asset_section_lookup` (`section`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_asset_assetgroup_map`
--

CREATE TABLE IF NOT EXISTS `jos_access_asset_assetgroup_map` (
  `asset_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_assets.id',
  `group_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_assetgroups.id',
  PRIMARY KEY  (`asset_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_asset_rule_map`
--

CREATE TABLE IF NOT EXISTS `jos_access_asset_rule_map` (
  `asset_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_assets.id',
  `rule_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_rules.id',
  PRIMARY KEY  (`asset_id`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_rules`
--

CREATE TABLE IF NOT EXISTS `jos_access_rules` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `section_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_sections.id',
  `section` varchar(100) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` varchar(255) default NULL,
  `ordering` int(11) NOT NULL default '0',
  `allow` int(1) unsigned NOT NULL default '0',
  `enabled` int(1) unsigned NOT NULL default '0',
  `access_type` int(1) unsigned NOT NULL default '0',
  `updated_date` int(10) unsigned NOT NULL default '0',
  `return` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_rule_name_lookup` (`section_id`,`name`),
  KEY `idx_access_check` (`enabled`, `allow`),
  KEY `idx_updated_lookup` (`updated_date`),
  KEY `idx_action_section_lookup` (`section`),
  KEY `idx_acl_manager_lookup` (`access_type`,`section_id`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_access_sections`
--

CREATE TABLE IF NOT EXISTS `jos_access_sections` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_section_name_lookup` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jos_access_sections`
--

INSERT INTO `jos_access_sections` (`id`, `name`, `title`, `ordering`) VALUES
(100, 'core', 'Core', -1);

-- --------------------------------------------------------

--
-- Table structure for table `jos_usergroups`
--

CREATE TABLE IF NOT EXISTS `jos_usergroups` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL default '0' COMMENT 'Adjacency List Reference Id',
  `left_id` int(10) unsigned NOT NULL default '0' COMMENT 'Nested Set Reference Id',
  `right_id` int(10) unsigned NOT NULL default '0' COMMENT 'Nested Set Reference Id',
  `title` varchar(100) NOT NULL default '',
  `section_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_sections.id',
  `section` varchar(100) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_usergroup_title_lookup` (`section`,`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` USING BTREE (`left_id`,`right_id`, `section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `jos_usergroups` (`id` ,`parent_id` ,`left_id` ,`right_id` ,`title` ,`section_id` ,`section`) VALUES
 (1 , 0, 1, 2, 'Public', 1, 'core');

-- --------------------------------------------------------

--
-- Table structure for table `jos_usergroup_rule_map`
--

CREATE TABLE IF NOT EXISTS `jos_usergroup_rule_map` (
  `group_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__usergroups.id',
  `rule_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_rules.id',
  PRIMARY KEY  (`group_id`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_users`
--

CREATE TABLE IF NOT EXISTS `jos_users` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Primary Key',
  `name` varchar(255) NOT NULL default '',
  `username` varchar(150) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `activated` int(1) unsigned NOT NULL default '0',
  `enabled` int(1) unsigned NOT NULL default '1',
  `class` int(1) unsigned NOT NULL default '1',
  `token` varchar(100) NOT NULL default '',
  `send_email` int(1) unsigned default '0',
  `register_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `last_visit_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `params` mediumtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_name` (`name`),
  KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_user_rule_map`
--

CREATE TABLE IF NOT EXISTS `jos_user_rule_map` (
  `user_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__users.id',
  `rule_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__access_rules.id',
  PRIMARY KEY  (`user_id`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jos_user_usergroup_map`
--

CREATE TABLE IF NOT EXISTS `jos_user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL default '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY  (`user_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
