<?php 
/**
* @version $Id: JEPrintPage.php  $
* @package Joomla
* @copyright Copyright (C) 2007 Pham Xuan Hau. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Josquote is donate software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See jooext.com for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport('joomla.event.plugin');

class plgContentJePrintPage extends JPlugin
{
   /**
    * Constructor
    *
    * For php4 compatability we must not use the __constructor as a constructor for
    * plugins because func_get_args ( void ) returns a copy of all passed arguments
    * NOT references.  This causes problems with cross-referencing necessary for the
    * observer design pattern.
    */
    function plgContentJePrintPage ( &$subject )
    {
            parent::__construct( $subject );
    }

	/**
	 * JePrintPage before display content method
	 *
	 * Method is called by the view and the results are imploded and displayed in a placeholder
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 * @return	string
	 */
	function onBeforeDisplayContent( &$article, &$params, $limitstart )
	{
		
		global $mainframe;
			// if plugin disable then exit
		if (!JPluginHelper::isEnabled('content', 'jeprintpage') ) {	return;	} 
		
		
		// tmpl=component&print=1&page=&option=com_content
		$isPopupPrint   = JRequest::getString('tmpl') == 'component';
		$isViewArticle  = JRequest::getString('view') == 'article';
		$isPrint   		= JRequest::getString('print') == '1';
		//$isPdf   		= JRequest::getString('format') == 'pdf';
		
		if ( !$isPopupPrint || !$isViewArticle ) {	return;	}
				
		$url = $mainframe->isAdmin() ? $mainframe->getSiteURL() : JURI::base();
		$doc 		=& JFactory::getDocument();
		$doc->addStyleSheet($url.'components/com_jeprintpage/css/jeprintpage.css'); 
		$doc->addStyleSheet($url.'components/com_jeprintpage/css/style.css'); 
		$doc->addScriptDeclaration("
		window.addEvent('domready', function(){
			var mySlide = new Fx.Slide('printpage-preview');			
			$('hide').addEvent('click', function(e){
				e = new Event(e);
				mySlide.slideOut();
				e.stop();
			});
		});"); 
		
		// get content in body tag
		$db 		= & JFactory::getDBO();

		// Copyright by JooExt 
		//<!-- You CAN NOT remove (or unreadable) those links without permission. 
		//Removing the link and template sponsor Please visit jooext.com or contact with e-mail (admin@jooext.com) 
		//If you don't want to link back to jooext.com, you can always pay a link removal donation fee of 10 USD. -->
		echo '<div id="printpage-preview">The printpage preview is generated by <a href="http://www.jooext.com/" target="_blank">JE PrintPage component</a> <span><a id="hide" href="#">Hide</a></span></div>';

		// select header and insert
		$query = 'SELECT c.content FROM #__jeprintpage AS c WHERE c.style = "html" AND c.position = "0" AND c.state = "1" ORDER BY c.ordering ASC';
		$db->setQuery($query);
		$obj = $db->loadResult();
		if ( $obj ) {
			$buffer = '<div class="printpageheader">' . $obj . "</div>";
		}
		
		
		echo $buffer;
	}

	/**
	 * Result after display content method
	 *
	 * Method is called by the view and the results are imploded and displayed in a placeholder
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 * @return	string
	 */
	function onAfterDisplayContent( &$article, &$params, $limitstart )
	{
		global $mainframe;
			// if plugin disable then exit
		if (!JPluginHelper::isEnabled('content', 'jeprintpage') ) {	return;	} 
		
		// tmpl=component&print=1&page=&option=com_content
		$isPopupPrint   = JRequest::getString('tmpl') == 'component';
		$isViewArticle  = JRequest::getString('view') == 'article';
		$isPrint   		= JRequest::getString('print') == '1';
		//$isPdf   		= JRequest::getString('format') == 'pdf';
		
		if ( !$isPopupPrint || !$isViewArticle ) {	return;	}
				
//		$componentName	= JRequest::getString('option');
		$url = $mainframe->isAdmin() ? $mainframe->getSiteURL() : JURI::base();
		$doc 		=& JFactory::getDocument();
		$doc->addStyleSheet($url.'components/com_jeprintpage/css/jeprintpage.css'); 

		// get content in body tag
		$db 		= & JFactory::getDBO();
		
		// select footer and insert
		$query = 'SELECT c.content FROM #__jeprintpage AS c WHERE c.style = "html" AND c.position = "1" AND c.state = "1" ORDER BY c.ordering ASC';
		$db->setQuery($query);
		$obj = $db->loadResult();
		if ( $obj ) {
			$buffer = '<div class="printpagefooter">'. $obj . "</div>";
		}
		return $buffer;
	}

}
?>